<?php
/**
 * Plugin Name: Stats.is Analytics
 * Plugin URI: https://stats.is
 * Description: Einfalt plugin til að bæta við Stats.is analytics tracking kóða á WordPress vefsíður.
 * Version: 1.0.0
 * Author: Stats
 * Author URI: https://stats.is
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: stats-is-analytics
 * Domain Path: /languages
 */

// Ef skráin er ekki kölluð gegnum WordPress, stoppa keyrslu
if (!defined('ABSPATH')) {
    exit;
}

// Skilgreina plugin stöðu
define('STATS_IS_VERSION', '1.0.0');
define('STATS_IS_PLUGIN_DIR', plugin_dir_path(__FILE__));

/**
 * Bæta við stillinga síðu í admin
 */
function stats_is_add_admin_menu() {
    add_options_page(
        'Stats.is Analytics',
        'Stats.is Analytics',
        'manage_options',
        'stats-is-analytics',
        'stats_is_options_page'
    );
}
add_action('admin_menu', 'stats_is_add_admin_menu');

/**
 * Skrá stillingar
 */
function stats_is_settings_init() {
    register_setting('stats_is_settings', 'stats_is_site_id');

    add_settings_section(
        'stats_is_settings_section',
        'Stillingar',
        'stats_is_settings_section_callback',
        'stats_is_settings'
    );

    add_settings_field(
        'stats_is_site_id',
        'Site ID',
        'stats_is_site_id_render',
        'stats_is_settings',
        'stats_is_settings_section'
    );
}
add_action('admin_init', 'stats_is_settings_init');

/**
 * Útfæra Site ID input
 */
function stats_is_site_id_render() {
    $site_id = get_option('stats_is_site_id');
    ?>
    <input type='text' 
           name='stats_is_site_id' 
           value='<?php echo esc_attr($site_id); ?>' 
           class='regular-text'
           placeholder='3fa8e90b-f6c2-4e11-bd93-2de1e994f076'>
    <p class="description">
        Afritaðu Site ID úr stjórnborðinu á <a href="https://stats.is" target="_blank">stats.is</a>
    </p>
    <?php
}

/**
 * Lýsing á stillinga hluta
 */
function stats_is_settings_section_callback() {
    echo '<p>Settu inn Site ID þitt frá Stats.is til að virkja analytics á vefsíðunni þinni.</p>';
}

/**
 * Stillinga síða
 */
function stats_is_options_page() {
    ?>
    <div class="wrap">
        <div style="display: flex; align-items: center; margin-bottom: 20px;">
            <img src="https://www.stats.is/images/logo.svg" 
                 alt="Stats.is" 
                 style="height: 40px; margin-right: 15px;">
            <h1>Stats.is Analytics</h1>
        </div>

        <?php
        // Sýna árangursmelding ef stillingum var vistað
        if (isset($_GET['settings-updated'])) {
            ?>
            <div class="notice notice-success is-dismissible">
                <p><strong>Stillingar vistaðar!</strong></p>
            </div>
            <?php
        }
        ?>

        <div class="card" style="max-width: 800px; margin-top: 20px;">
            <h2>Um Stats.is</h2>
            <p>Stats.is er einfaldur og persónuverndarmiðaður analytics hugbúnaður fyrir vefsíður.</p>
            
            <h3>Hvernig á að nota</h3>
            <ol>
                <li>Skráðu þig inn á <a href="https://stats.is" target="_blank">stats.is</a></li>
                <li>Farðu í Stillingar á stjórnborðinu</li>
                <li>Afritaðu Site ID þitt</li>
                <li>Límdu það hér að neðan og vistaðu</li>
            </ol>

            <h3>Þarftu hjálp?</h3>
            <ul>
                <li>Netfang: <a href="mailto:stats@stats.is">stats@stats.is</a></li>
                <li>Sími: 537-7990</li>
                <li>Vefur: <a href="https://stats.is" target="_blank">stats.is</a></li>
            </ul>
        </div>

        <form action='options.php' method='post' style="margin-top: 30px;">
            <h2>Grunnstillingar</h2>
            <?php
            settings_fields('stats_is_settings');
            do_settings_sections('stats_is_settings');
            submit_button('Vista stillingar');
            ?>
        </form>

        <?php
        // Sýna hvaða kóði verður bætt við ef Site ID er sett inn
        $site_id = get_option('stats_is_site_id');
        if (!empty($site_id)) {
            ?>
            <div class="card" style="max-width: 800px; margin-top: 30px; background: #f6f7f7;">
                <h3>Tracking kóði sem er virkur á síðunni</h3>
                <p>Eftirfarandi kóði er sjálfkrafa bætt við í <code>&lt;head&gt;</code> hluta vefsíðunnar:</p>
                <pre style="background: white; padding: 15px; border: 1px solid #ddd; overflow-x: auto;"><code>&lt;script defer src="https://stats.is/t.js?site=<?php echo esc_html($site_id); ?>"&gt;&lt;/script&gt;</code></pre>
            </div>
            <?php
        }
        ?>
    </div>
    <?php
}

/**
 * Bæta við Stats.is tracking kóða í <head>
 */
function stats_is_add_tracking_code() {
    $site_id = get_option('stats_is_site_id');
    
    // Athuga hvort Site ID sé til staðar
    if (empty($site_id)) {
        return;
    }

    // Ekki bæta við tracking kóða fyrir admin notendur ef þeir eru innskráðir
    // (þú getur fjarlægt þessa línu ef þú vilt tracka admin líka)
    if (current_user_can('manage_options')) {
        return;
    }

    // Bæta við tracking script
    echo "\n<!-- Stats.is Analytics -->\n";
    echo '<script defer src="https://stats.is/t.js?site=' . esc_attr($site_id) . '"></script>' . "\n";
    echo "<!-- / Stats.is Analytics -->\n\n";
}
add_action('wp_head', 'stats_is_add_tracking_code');

/**
 * Bæta við stillinga hlekk á plugin lista síðunni
 */
function stats_is_add_settings_link($links) {
    $settings_link = '<a href="options-general.php?page=stats-is-analytics">Stillingar</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'stats_is_add_settings_link');

/**
 * Hreinsa stillingar þegar plugin er eytt
 */
function stats_is_uninstall() {
    delete_option('stats_is_site_id');
}
register_uninstall_hook(__FILE__, 'stats_is_uninstall');
